/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.service;

import org.fortiss.tooling.kernel.extension.ITutorialProvider;
import org.fortiss.tooling.kernel.service.ITutorialService;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;
import org.fortiss.tooling.kernel.ui.extension.ITutorialUIProvider;
import org.fortiss.tooling.kernel.ui.extension.ITutorialUIWhitelistProvider;
import org.fortiss.tooling.kernel.ui.internal.TutorialUIService;

/**
 * Interface for the UI part of {@link ITutorialService}.
 * 
 * @author hoelzl
 */
public interface ITutorialUIService extends ITutorialUIWhitelistProvider {
	/** Returns the service instance. */
	public static ITutorialUIService getInstance() {
		return TutorialUIService.getInstance();
	}

	/** Programmatically register a tutorial provider. */
	void registerTutorialUIProvider(Class<? extends ITutorialProvider> nonUIprovider,
			Class<? extends ITutorialUIProvider> uiProvider);

	/** Opens the editor for the given tutorial step. */
	void openInEditor(ITutorialStepUI selected);
}
