/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.fortiss.tooling.kernel.ui.service.IActionService;

/**
 * Utility functions for dealing with actions.
 * 
 * @author aravantinos
 */
public class ActionUtils {

	/** Key adapter to deal with copy/paste/delete/... done through the keyboard. */
	public static class ViewerKeyAdapter extends KeyAdapter {
		/** Constructor. */
		public ViewerKeyAdapter() {
		}

		/** {@inheritDoc} */
		@Override
		public void keyReleased(KeyEvent e) {
			if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x63) {
				IActionService.getInstance().runGlobalCopyAction();
			} else if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x76) {
				IActionService.getInstance().runGlobalPasteAction();
			} else if(e.keyCode == SWT.DEL) {
				IActionService.getInstance().runGlobalDeleteAction();
			} else if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x78) {
				IActionService.getInstance().runGlobalCutAction();
			} else if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x7A) {
				IActionService.getInstance().runGlobalUndoAction();
			} else if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x79) {
				IActionService.getInstance().runGlobalRedoAction();
			} else if(e.keyCode == SWT.F2) {
				IActionService.getInstance().runGlobalRenameAction();
			} else if((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 0x61) {
				IActionService.getInstance().runGlobalSelectAllAction();
			}
		}
	}
}
