/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.ui.dnd.CompositionServiceLocalDNDTransfer;
import org.fortiss.tooling.kernel.ui.dnd.ElementCompositionSource;

/**
 * Utility methods for drag and drop support.
 * 
 * @author hoelzl
 */
public final class DragAndDropUtils {

	/**
	 * Extracts the EObject contained in the given drop object.
	 * 
	 * @param data
	 *            the transfered object of which to extract the element
	 * @return the extracted {@link EObject}
	 */
	public static EObject extractDroppedEObject(Object data) {
		// if the dropped object is a selection, extract content
		if(data instanceof IStructuredSelection && !((IStructuredSelection)data).isEmpty()) {
			data = ((IStructuredSelection)data).getFirstElement();
		}

		if(data instanceof Prototype) {
			// create copy of prototype
			return ((Prototype)data).getPrototypeCopy();
		}
		if(data instanceof EObject) {
			return (EObject)data;
		}
		if(data instanceof ElementCompositionSource) {
			return ((ElementCompositionSource)data).getDesignatedElement();
		}
		return null;
	}

	/**
	 * Returns the transfered element composition source.
	 * 
	 * @return the transfered {@link ElementCompositionSource}
	 */
	public static ElementCompositionSource getElementCompositionSourceFromTransfer() {
		return (ElementCompositionSource)CompositionServiceLocalDNDTransfer.getInstance()
				.getObject();
	}

	/**
	 * Returns the preferred transfer for the DND operation via composition
	 * service.
	 * 
	 * @return {@link CompositionServiceLocalDNDTransfer} singleton instance
	 */
	public static Transfer[] getCompositionServiceTransfers() {
		return new Transfer[] {CompositionServiceLocalDNDTransfer.getInstance()};
	}
}
