/*-------------------------------------------------------------------------+
| Copyright 2014 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import java.util.Comparator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.fortiss.tooling.kernel.utils.HierarchicalNameComparator;

/**
 * {@link ViewerComparator} whose {@link #compare(Viewer, Object, Object)} method sorts
 * {@link EObject} model elements by wrapping {@link HierarchicalNameComparator}).
 * 
 * @author barner
 */
public class HierarchicalNameViewerComparator extends ViewerComparator {

	/** Underlying {@link Comparator} that performs the actual work. */
	private static HierarchicalNameComparator comp = new HierarchicalNameComparator();

	/** {@inheritDoc} */
	@Override
	public int compare(Viewer viewer, Object o1, Object o2) {
		return comp.compare(o1, o2);
	}
}
