/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.extension.IModelEditor;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.internal.editor.ExtendableMultiPageEditor;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

/**
 * Utility methods related to editors.
 * 
 * @author aravantinos
 */
public class KernelUIUtils {
	/**
	 * Returns the opened edited of the given class (if it exists).
	 * 
	 * @param editorClazz
	 *            Class of the editor you would like to get.
	 * @param activateEditor
	 *            Set to true if you want the editor to be not just returned, but also activated in
	 *            the GUI.
	 * @return the opened editor of the given class if any.
	 */
	@SuppressWarnings("unchecked")
	public static <T extends EObject, E extends IModelEditor<T>> E
			getOpenedEditor(Class<E> editorClazz, boolean activateEditor) {
		IModelEditor<?> editor = IModelEditorBindingService.getInstance().getActiveEditor();
		if(editorClazz.isInstance(editor)) {
			return (E)editor;
		}
		if(editor != null && editor.getSite() instanceof MultiPageEditorSite) {
			MultiPageEditorSite multiEditor = (MultiPageEditorSite)editor.getSite();
			ExtendableMultiPageEditor multiPage =
					(ExtendableMultiPageEditor)multiEditor.getMultiPageEditor();
			E saEditor = multiPage.getPageEditor(editorClazz);
			if(activateEditor) {
				multiPage.setActiveEditor(saEditor);
			}
			return saEditor;
		}
		return null;
	}

	/**
	 * Returns a UI name for the given {@code element}, or {@code null} in case it cannot be
	 * determined.
	 */
	public static String getName(Object element) {
		if(!(element instanceof EObject)) {
			return null;
		}
		EObject eObject = (EObject)element;
		IModelElementHandler<EObject> modelElementHandler =
				IModelElementHandlerService.getInstance().getModelElementHandler(eObject);
		if(modelElementHandler != null) {
			return modelElementHandler.getName(eObject);
		} else if(element instanceof INamedElement) {
			return ((INamedElement)element).getName();
		}

		return null;
	}

	/**
	 * Returns an {@link Image} for the given {@code element}, or {@code null} in case it cannot be
	 * determined.
	 */
	public static Image getImage(Object element) {
		if(element instanceof EObject) {
			EObject eObj = (EObject)element;
			IModelElementHandler<EObject> modelElementHandler =
					IModelElementHandlerService.getInstance().getModelElementHandler(eObj);
			if(modelElementHandler != null) {
				return modelElementHandler.getIcon(eObj);
			}
		}
		return null;
	}
}
