/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.conqat.lib.commons.assertion.CCSMPre;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.tooling.kernel.ui.internal.databinding.EObjectObservableValue;

/**
 * Utility methods for creating observables for {@link EObject} models.
 * 
 * @author hummel
 * @author hoelzl
 */
public class ObservableUtils {

	/**
	 * Returns an observable for the given object and structural feature.
	 * 
	 * @param eObject
	 *            the element to be observed
	 * @param structuralFeature
	 *            the elements feature to be observed
	 * @return the observable value
	 */
	public static IObservableValue<?> observeValue(EObject eObject,
			EStructuralFeature structuralFeature) {
		return observeValue(Realm.getDefault(), eObject, structuralFeature);
	}

	/**
	 * Returns an observable for the given object and structural feature.
	 * 
	 * @param realm
	 *            the data binding realm to be used
	 * @param eObject
	 *            the element to be observed
	 * @param structuralFeature
	 *            the elements feature to be observed
	 * @return the observable value
	 */
	public static IObservableValue<?> observeValue(Realm realm, EObject eObject,
			EStructuralFeature structuralFeature) {
		CCSMPre.isTrue(eObject != null, "Can not observe null value!");
		return new EObjectObservableValue(realm, eObject, structuralFeature);
	}
}
