/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;

/**
 * This class provides the constants for the tabbed property framework.
 * 
 * <P>
 * By default, the kernel registers two property tabs. The
 * <code>org.fortiss.tooling.kernel.ui.property.tab.general</code> tab supports a default section
 * for {@link INamedCommentedElement} with editing support for <code>name</code> and
 * <code>comment</code>. The <code>org.fortiss.tooling.kernel.ui.property.tab.internal</code> tab
 * shows the unique internal ID of an {@link IIdLabeled} model element. This ID cannot be changed
 * manually.
 * 
 * <P>
 * Property section extensions should consider to use {@link PropertySectionBase} as a starting
 * point for property sections. Property section should be registered as required by the tabbed
 * property framework using the IDs provided by class.
 * 
 * @see TabbedPropertySheetPage
 * 
 * @author hoelzl
 */
public class PropertiesConstantUtils {

	/** The tabbed property sheet contributor ID. */
	public static final String TABBED_PROPERTY_CONTRIBUTOR_ID =
			"org.fortiss.tooling.kernel.ui.properties.Contributor";

	/** The property category used for all sections of the contributor. */
	public static final String PROPERTY_CATEGORY = "main";

	/** The ID of the general properties tab. */
	public static final String GENERAL_PROPERTY_TAB_ID =
			"org.fortiss.tooling.kernel.ui.property.tab.general";

	/** The ID of the internal properties tab. */
	public static final String INTERNAL_PROPERTY_TAB_ID =
			"org.fortiss.tooling.kernel.ui.property.tab.internal";
}
