/*-------------------------------------------------------------------------+
| Copyright 2012 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * Factory class for easier creation of different widgets.
 * 
 * @author ratiu
 */
public class WidgetsFactory {

	/**
	 * Creates a new spinner.
	 * 
	 * @param parent
	 *            - the parent component
	 * @param minimum
	 *            - minimum of the spinner value
	 * @param maximum
	 *            - maximum of the spinner value
	 * @param selection
	 *            - initial selection of the spinner
	 * @return the spinner object
	 */
	public static Spinner createSpinner(Composite parent, int minimum, int maximum, int selection) {
		Spinner spinner = new Spinner(parent, SWT.BORDER);
		spinner.setMinimum(minimum);
		spinner.setMaximum(maximum);
		spinner.setIncrement(1);
		spinner.setSelection(selection);
		return spinner;
	}

	/**
	 * Creates a new text field with a given size in characters. The text must be in a container
	 * with GridLayout.
	 * 
	 * @param parent
	 *            - the parent component
	 * @param style
	 *            - the style
	 * @param initialText
	 *            - the initial value
	 * @param charsNumber
	 *            - maximum number of characters of this text
	 * @return the text field
	 */
	public static Text createText(Composite parent, int style, String initialText,
			int charsNumber) {
		Text text = new Text(parent, style);
		new UndoRedoImpl(text);
		text.setText(initialText);
		GC gc = new GC(text);
		FontMetrics fm = gc.getFontMetrics();
		// Cast double -> int is safe because FontMetrics.getAverageCharacterWidth() is implemented
		// by calling "int FontMetrics.getAverageCharWidth()"
		int width = charsNumber * (int)fm.getAverageCharacterWidth();
		int height = fm.getHeight();
		gc.dispose();
		text.setLayoutData(new GridData(width, height));
		parent.pack();
		return text;
	}

	/** Substitute to FormToolkit.createText in order to add undo/redo functionality. */
	public static Text createTextWithUndo(FormToolkit toolkit, Composite parent, String value,
			int style) {
		Text res = toolkit.createText(parent, value, style);
		new UndoRedoImpl(res);
		return res;
	}

	/** Substitute to FormToolkit.createText in order to add undo/redo functionality. */
	public static Text createTextWithUndo(FormToolkit toolkit, Composite parent, String value) {
		return createTextWithUndo(toolkit, parent, value, SWT.NONE);
	}
}
