#!/bin/bash

set -e
title="[FF1 Pi]"

# Hostname (e.g. yellowpi1)
host=$1

# Create hostnameReachable.
if ping -c 1 $host &>/dev/null ; then
    hostnameReachable=$host
elif ping -c 1 $host.local &>/dev/null ; then
    hostnameReachable="$host.local"
else
    exit 1
fi

##############################
####### DEBUGGING INFO #######
##############################
echo ""
echo "$title Host name: $host."
echo "$title Printing: /tmp/start_middleware.log."
echo "$title hostnameReachable: $hostnameReachable."
echo ""

ssh ubuntu@$hostnameReachable << EOF
  cat /tmp/start_middleware.log
EOF
