#!/bin/bash

set -e
title="[FF1 Pi]"

# Hostname (e.g. yellowpi1)
host=$1

# Path of source folder with FMUs and config.json
sourceFolderPath=$2

# ROS launch file name for host
launchFileName=$3

# Get all FMU file names
fmuNames=""
for arg in "$@"
do
    if [[ $arg == *.fmu ]] 
    then
        fmuNames="$fmuNames $arg";
    fi
done

# Create hostnameReachable.
if ping -c 1 $host &>/dev/null ; then
    hostnameReachable=$host
elif ping -c 1 $host.local &>/dev/null ; then
    hostnameReachable="$host.local"
else
    exit 1
fi

##############################
####### DEBUGGING INFO #######
##############################
echo ""
echo "$title Host name: $host."
echo "$title Generated files in: $sourceFolderPath."
echo "$title ROS launch file name: $launchFileName."
echo "$title FMUs for host: $fmuNames."
echo "$title hostnameReachable: $hostnameReachable."
echo ""

scp -r $sourceFolderPath/* ubuntu@$hostnameReachable:/tmp
ssh ubuntu@$hostnameReachable << EOF
  echo "Stopping possibly remaining processes (if nothing is found, nothing will be displayed) ..."
  killall -9 -v -q ros2 adapter master slave ff1_middleware_node || true

  echo "Setting up the FMU share locations ..."
  cd /home/ubuntu/colcon_ws/src/ff1_middleware/share
  rm *.fmu *.json
  cd /tmp
  mv $fmuNames /home/ubuntu/colcon_ws/src/ff1_middleware/share/x86_64
  mv *.json /home/ubuntu/colcon_ws/src/ff1_middleware/share

  echo "Setting up the middleware launch structure file ..."
  rm /home/ubuntu/colcon_ws/src/ff1_middleware/launch/*
  mv $launchFileName /home/ubuntu/colcon_ws/src/ff1_middleware/launch/ff1_middleware.launch.py

  echo "Executing middleware deployment bash ..."
  /home/ubuntu/colcon_ws/src/ff1_middleware/deploy_middleware.bash /home/ubuntu/colcon_ws > /tmp/ff1_middleware.log 2>&1
EOF

echo "$title Logs of compilation can be found in /tmp/ff1_middleware.log on $hostnameReachable."
echo "$title Compilation of middleware and FMUs successful on $hostnameReachable."
