#!/bin/bash

set -e
title="[FF1 Pi]"

IFS=' ' read -r -a array <<< "$@"

for arg in "${array[@]}" # Iterate through all hostnames.
do
    host=$arg
    # Test ping.
    echo "$title Trying to ping your target..."
    if ping -c 5 $host &>/dev/null ; then
        echo "$title Your target is pingable as $host!"
        hostnameReachable=$host
    elif ping -c 5 $host.local &>/dev/null ; then
        echo "$title Your target is pingable as $host.local!"
        hostnameReachable="$host.local"
    else
        echo "$title Sorry, cannot ping your target $host yet! Try again later."
        exit 1
    fi
    # Test SSH connection.
    ssh -q ubuntu@$hostnameReachable exit # Throws code 255 in case of unsuccessful SSH test.
done
