#!/bin/bash

set -e
title="[FF1 Pi]"

# Hostname (e.g. yellowpi1)
host=$1

# Create hostnameReachable.
if ping -c 1 $host &>/dev/null ; then
    hostnameReachable=$host
elif ping -c 1 $host.local &>/dev/null ; then
    hostnameReachable="$host.local"
else
    exit 1
fi

##############################
####### DEBUGGING INFO #######
##############################
echo ""
echo "$title Host name: $host."
echo "$title hostnameReachable: $hostnameReachable."
echo ""

ssh ubuntu@$hostnameReachable << EOF
  echo "Stopping all found processes regarding rover (if nothing is found, nothing will be displayed) ..."
  killall -9 -v -q ros2 adapter master slave ff1_middleware_node || true
EOF
