/*--------------------------------------------------------------------------+
|                                                                          |
| Copyright 2021 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
grammar PresenceCondition;

options {
    language = Java;
    //superClass = RestrictionParserBase;
}

@lexer::header {
/*--------------------------------------------------------------------------+
|                                                                          |
| Copyright 2021 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.variability.presence.parser;

/**
 * Generaded code - DO NOT MODIFY!
 *
 * Generation via ANTLR, see the script /tools/generate_unix.
 *  
 * @author bayha
 */
}

@parser::header {
/*--------------------------------------------------------------------------+
|                                                                          |
| Copyright 2021 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.variability.presence.parser;

/**
 * Generaded code - DO NOT MODIFY!
 *
 * Generation via ANTLR, see the script /tools/generate_unix.
 *  
 * @author bayha
 */

import static org.fortiss.variability.model.VariabilityModelElementFactory.createOrPC;
import static org.fortiss.variability.model.VariabilityModelElementFactory.createAndPC;
import static org.fortiss.variability.model.VariabilityModelElementFactory.createNotPC;
import static org.fortiss.variability.model.VariabilityModelElementFactory.createLiteralPC;
import static org.fortiss.variability.model.VariabilityModelElementFactory.createDefaultPC;
 
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.presence.*;

import org.eclipse.emf.ecore.EObject;
}

@parser::members {
/**
 * Context for parsing PresenceCondition. I.e. an {@link EObject}, contained in the FileProject, for
 * which the parsing result is intended.
 */
EObject context;

/**
 * Constructor.
 *
 * @param input
 *            TokenStream, which provides input for the parser. 				
 * @param context
 *            An {@link EObject}, contained in the FileProject, for
 *            which the parsing result is intended.
 */
public PresenceConditionParser(TokenStream input, EObject context){
	this(input);
  	
	this.context = context;
}
} 

/*------------------------------------------------------------------
 * PARSER RULES
 *------------------------------------------------------------------*/
// Precendence defined by the order of rules. Least precedence first...	  
	  
// startRule
presenceConditionEOF returns [PresenceCondition rest]	
	: presenceConditionTerm? NL? {$rest = $presenceConditionTerm.rest;}
	| DEFAULT NL? {$rest = createDefaultPC();};

presenceConditionTerm	returns [PresenceConditionTerm rest]	
	: atom {$rest = $atom.literal;}
	| (WS)*'('(WS)* r=presenceConditionTerm (WS)*')'(WS)* {$rest = $r.rest;} 
	| r1=presenceConditionTerm OR r2=presenceConditionTerm {$rest = createOrPC($r1.rest, $r2.rest, _ctx.getText());}
	| r1=presenceConditionTerm AND r2=presenceConditionTerm {$rest = createAndPC($r1.rest, $r2.rest, _ctx.getText());}
	| NOT r=presenceConditionTerm {$rest = createNotPC($r.rest, _ctx.getText());};

atom returns [LiteralPC literal]	
	: LABEL {$literal = createLiteralPC($LABEL.text, context);};
	  
	  
/*------------------------------------------------------------------
 * LEXER RULES
 *------------------------------------------------------------------*/

fragment DIGIT 	:		'0'..'9' ;
fragment LOWER	:		'a'..'z';
fragment UPPER	: 		'A'..'Z';
fragment UMLAUT :		'' | '' | '' | '' | '' | '' | '';
fragment SPECIAL:		'&' | '@' | '' | '$' | '' | '';
fragment SEPARATOR :	'[' | ']' | '_' | '-' | '+' | '/' | '\\' | '.' | ',' | '=';

fragment LETTER : LOWER | UPPER | UMLAUT | SPECIAL;
fragment ALPHANUM : LETTER | DIGIT | SEPARATOR;

// white space
//WS : ( '\t' | ' ' | '\r' | '\n'| '\u000C' );
WS: (' ' | '\t') -> skip;
NL: '\r'? '\n';

DEFAULT	:	'DEFAULT';

LABEL	: ALPHANUM+;

fragment AND_OP	:	'AND';
fragment OR_OP	:	'OR';
fragment NEG_OP	:	'NOT';

AND	:	(WS)*(AND_OP)(WS)*;
OR	:	(WS)*(OR_OP)(WS)*;
NOT	:	(WS)*(NEG_OP)(WS)*;

